#include <iostream>
#include <vector>
#include <string>
#include "fen.h"
#include "utils.h"
#include "log.h"

using namespace std;

const string startfen = "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1";
//r3k2r/p1ppqpb1/bn2pnp1/3PN3/1p2P3/2N2Q1p/PPPBBPPP/R3K2R w KQkq - 0 1 ;D1 48 ;D2 2039 ;D3 97862 ;D4 4085603 ;D5 193690690 ;D6 8031647685
//const string startfen = "r3k2r/p1ppqpb1/bn2pnp1/3PN3/1p2P3/2N2Q1p/PPPBBPPP/R3K2R w KQkq - 0 1";

void setepdposition(const string epdline, cBoard &brd, cMaterial &mat, cHistory &his)
{
    /***
    EPD will have:
    7x "/" indicating end of rank
    Start at A8
    Board section will be followed by
        -active piece
        -castling perm
        -ep square
        -halfmove clock
        -fullmovenumber

    Total of 6 sections
    ***/

    brd.clearboard();
    mat.clearpcelists();
    his.clearhistory();

    vector<string> epdsections;
    char delim = ' ';
    stringsplitter(epdline,  delim, epdsections);

    uint i;

	//cout<<"\n epdsections.size() "<<epdsections.size();

    if(epdsections.size() < 4)
    {
        cout<<"\n ERROR FEN - Too few parameters supplied. ";
        cout<<"\n String supplied: ";
		cout<<epdline;
        cout<<"\n sections read in: ";
        for(i = 0; i < epdsections.size(); ++i)
        {
         cout<<"\n"<<i<<" < "<<epdsections[i]<<" >";
		}
       return;
    }

    if(logger.islog())
    {
        logger.file<<" setting position fen : \n"<<epdline<<"\n";
    }


    /**
    now split the board detail into ranks
    **/
    vector<string> boarddetail;
    delim = '/';
    stringsplitter(epdsections[0],  delim, boarddetail);

    if(boarddetail.size() != 8)
    {
        cout<<"\n ERROR FEN - Too few/many ranks supplied. ";
        cout<<"\n sections read in: ";
       for(i = 0; i< boarddetail.size(); ++i)
       {
		  cout<<"\n"<<i<<" < "<<boarddetail[i]<<" >";
       }
       return;
    }

    uint f,r,j;
    uint s;
    string rankline;
    for(i = 0; i < boarddetail.size(); ++i)
    {
          f = 0;
          r = 7-i;

          for(j = 0; j < boarddetail[i].length(); ++j)
          {
              if(boarddetail[i].at(j) >= '1' && boarddetail[i].at(j) <= '8')
              {
                  f += boarddetail[i].at(j)-'0';
                  continue;
              }
              else
              {
                  ASS(f<=FILEH&&f>=FILEA);
                  ASS(r<=RANK8&&r>=RANK1);
                  s = fr2sq(f,r);
                  ASS(onbrd(s));

                  switch (boarddetail[i].at(j))
                  {
                      case 'P': brd.setpiece(pwP,s);break;
                      case 'B': brd.setpiece(pwB,s);break;
                      case 'N': brd.setpiece(pwN,s);break;
                      case 'R': brd.setpiece(pwR,s);break;
                      case 'Q': brd.setpiece(pwQ,s);break;
                      case 'K': brd.setpiece(pwK,s);break;
                      case 'p': brd.setpiece(pbP,s);break;
                      case 'b': brd.setpiece(pbB,s);break;
                      case 'n': brd.setpiece(pbN,s);break;
                      case 'r': brd.setpiece(pbR,s);break;
                      case 'q': brd.setpiece(pbQ,s);break;
                      case 'k': brd.setpiece(pbK,s);break;
                      default: cout<<"\n piece char error <"<<boarddetail[i].at(j)<<">"; return;
                  };
                  f++;
              }
          }
    }


    if(epdsections[1].at(0) == 'w') brd.setside(cW);
   else if(epdsections[1].at(0) == 'b') brd.setside(cB);
   else
   {
	   cout<<"\n SIDE error - input < "<<epdsections[1]<<" >";
	   return;
   }


   for(i = 0; i < epdsections[2].length(); ++i)
   {
       if(epdsections[2].at(i) == '-') continue;
       else if(epdsections[2].at(i) == 'K') brd.setcastle(WCAKS);
       else if(epdsections[2].at(i) == 'Q') brd.setcastle(WCAQS);
       else if(epdsections[2].at(i) == 'k') brd.setcastle(BCAKS);
       else if(epdsections[2].at(i) == 'q') brd.setcastle(BCAQS);
       else
	   {
	   cout<<"\n castle error - input < "<<epdsections[2]<<" >";
	   return;
       }
   }

   //if(epdsections[3] != "-")
   if(epdsections[3].length() == 2)
   {
       brd.setenpas(str2sq(epdsections[3]));
   }

  if(epdsections.size() > 4)
  {
   i = strtoint(epdsections[4], 0);
   if(i<0||i>100) i = 0;
   brd.setfifty(i);
  }

   mat.setpiecelists(brd.p2board());

   brd.setkey(genhashkey(brd));
   brd.setpawnkey(genpawnkey(brd));
#ifdef DEBUG
 if(logger.islog())
 brd.logboard();
#endif


   ASS(position_check(brd, mat));
/*
   #ifdef DEBUG
   brd.printboard();
   mat.printmaterial();
   #endif
*/
}


//mirror the position (set white as black, set black as white
void mirrorboard(cBoard &brd, cMaterial &mat, cHistory &his)
{
    uint sq64,sq128,inv128;

    uint holdside = brd.getside();
    uint holdfifty = brd.getfifty();
    uint holdenpas = brd.getenpas();
    uint holdcastle = brd.getcastle();

    uint backup_board[BRDSQ];
    for(sq128=A1; sq128 < BRDSQ; ++sq128) backup_board[sq128] = brd.getpiece(sq128);

    brd.clearboard();
    mat.clearpcelists();
    his.clearhistory();

    for (sq64=0; sq64<64; ++sq64)
    {
       sq128 = sqfrom64(sq64);
       inv128 = sqrev[sq128];
       ASS(onbrd(sq128));
       ASS(onbrd(inv128));
       if(backup_board[sq128] == pwK) brd.setpiece(pbK,inv128);
       else if(backup_board[sq128] == pwQ) brd.setpiece(pbQ,inv128);
       else if(backup_board[sq128] == pwR) brd.setpiece(pbR,inv128);
       else if(backup_board[sq128] == pwB) brd.setpiece(pbB,inv128);
       else if(backup_board[sq128] == pwN) brd.setpiece(pbN,inv128);
       else if(backup_board[sq128] == pwP) brd.setpiece(pbP,inv128);
       else if(backup_board[sq128] == pbK) brd.setpiece(pwK,inv128);
       else if(backup_board[sq128] == pbQ) brd.setpiece(pwQ,inv128);
       else if(backup_board[sq128] == pbR) brd.setpiece(pwR,inv128);
       else if(backup_board[sq128] == pbB) brd.setpiece(pwB,inv128);
       else if(backup_board[sq128] == pbN) brd.setpiece(pwN,inv128);
       else if(backup_board[sq128] == pbP) brd.setpiece(pwP,inv128);
       else brd.setpiece(pE,inv128);
    }

   brd.setside(holdside^1);
   brd.setcastle(0);

   if (holdcastle & 8)  brd.setcastle(BCAKS);
   if (holdcastle & 4)  brd.setcastle(BCAQS);
   if (holdcastle & 2)  brd.setcastle(WCAKS);
   if (holdcastle & 1)  brd.setcastle(WCAQS);

   if(onbrd(holdenpas)) brd.setenpas(sqrev[holdenpas]);

   brd.setfifty(holdfifty);
   brd.setkey(genhashkey(brd));
   brd.setpawnkey(genpawnkey(brd));
   mat.setpiecelists(brd.p2board());


   ASS(position_check(brd,mat));
}

string fenfromboard(cBoard &brd, cMaterial &mat)
{
  uint file;
  int rank;
  string epdline;
  uint *p2brd = brd.p2board();
  uint sq;
  uint empty;
  uint pce;
  uint index;
  uint castle;
  const char counter[9] = {'0','1','2','3','4','5','6','7','8'};
  vector<string> ranks;
  string temp,temp2;
  char start = '0';

#ifdef DEBUG
  cout<<"\n converting following to epd:";
  brd.printboard();
  cout<<endl;
#endif

  for( rank = 7; rank>=0; rank--)
  {
      temp.clear();
      for( file = FILEA; file<=FILEH; ++file)
      {
       sq = fr2sq(file,rank);
       ASS(onbrd(sq));
       pce = p2brd[sq];
       ASS(pce>=pE&&pce<=pbK);
       temp+=piecechar(pce);
      }

      //now replace the dots with a number
      ASS(temp.length()==8);
      empty=0;
      temp2.clear();

      for(index = 0; index < temp.length(); ++index)
      {
          if(temp[index]!='.')
          {
            if(empty!=0)
            {
                temp2+=counter[empty];
                empty=0;
            }
            temp2+=temp[index];
            continue;
          }
          ASS(temp[index]=='.');
          empty++;
      }
      if(empty!=0)
      {
          temp2+=counter[empty];
      }
      if(rank>0) temp2+='/';
      ranks.push_back(temp2);
  }

  for(index = 0; index < ranks.size(); ++index)
  {
      epdline+=ranks[index];
  }


  //epd line now has the board, trivial to add the remaining parts....
  //side;
  epdline+=' ';
  epdline+=colourchar(brd.getside());

  //castle permission
  epdline+=' ';
  castle = brd.getcastle();
  temp.clear();

  if (castle & WCAKS)  temp+='K';
  if (castle & WCAQS)  temp+='Q';
  if (castle & BCAKS)  temp+='k';
  if (castle & BCAQS)  temp+='q';

  epdline+=temp;

  //epsqaure
  epdline+=' ';
  if(onbrd(brd.getenpas())) epdline+=printsquare(brd.getenpas());
  else epdline+='-';

  //fifty
  epdline+=' ';
  epdline+=(start+brd.getfifty());

  //fullmove count
  epdline+=' ';
  epdline+=(start+(brd.returnply()/2)+1);

  return epdline;
}

